/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarUtils;
import example.CalendarViewTableModel;
import example.MonthScrollPane;
import example.MonthTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        JLabel monthLabel = new JLabel("", 0);
        MonthTable monthTable = new MonthTable();
        MainPanel.updateMonthView(monthTable, monthLabel, LocalDate.now(ZoneId.systemDefault()));
        JButton prev = new JButton("<");
        prev.addActionListener(e -> {
            LocalDate d = monthTable.getCurrentLocalDate().minusMonths(1L);
            MainPanel.updateMonthView(monthTable, monthLabel, d);
        });
        JButton next = new JButton(">");
        next.addActionListener(e -> {
            LocalDate d = monthTable.getCurrentLocalDate().plusMonths(1L);
            MainPanel.updateMonthView(monthTable, monthLabel, d);
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add(monthLabel);
        p.add((Component)prev, "West");
        p.add((Component)next, "East");
        this.add((Component)p, "North");
        this.add(new MonthScrollPane(monthTable));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static void updateMonthView(MonthTable table, JLabel label, LocalDate date) {
        table.setCurrentLocalDate(date);
        Locale locale = Locale.getDefault();
        DateTimeFormatter fmt = CalendarUtils.getLocalizedYearMonthFormatter(locale);
        String txt = date.format(fmt.withLocale(locale));
        label.setText(CalendarUtils.getLocalizedYearMonthText(txt));
        table.setModel(new CalendarViewTableModel(date));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST AutoResizeTableHeader");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

