/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.DiagonallySplitCellLayerUI;
import example.MonthTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class CalendarTableRenderer
extends DefaultTableCellRenderer {
    private static final Color SUNDAY_FGC = new Color(11538970);
    private static final Color SATURDAY_FGC = new Color(1708720);
    private final JPanel panel = new JPanel(new BorderLayout());
    private LocalDate currentLocalDate;

    CalendarTableRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        JLayer<JPanel> c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
        if (value instanceof LocalDate && c instanceof JLabel && table instanceof MonthTable) {
            boolean isLastRow;
            LocalDate d = (LocalDate)value;
            JLabel l = (JLabel)((Object)c);
            l.setText(Integer.toString(d.getDayOfMonth()));
            l.setVerticalAlignment(1);
            l.setHorizontalAlignment(2);
            this.panel.setBackground(l.getBackground());
            this.currentLocalDate = ((MonthTable)table).getCurrentLocalDate();
            this.updateWeekColor(d, table, c, selected);
            LocalDate nextWeekDay = d.plusDays(7L);
            boolean bl = isLastRow = row == table.getModel().getRowCount() - 1;
            if (isLastRow && CalendarTableRenderer.isDiagonallySplitCell(nextWeekDay, this.currentLocalDate)) {
                JLabel sub = new JLabel(Integer.toString(nextWeekDay.getDayOfMonth()));
                sub.setFont(l.getFont());
                sub.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                sub.setOpaque(false);
                sub.setVerticalAlignment(3);
                sub.setHorizontalAlignment(4);
                this.updateWeekColor(d, table, sub, selected);
                this.panel.removeAll();
                this.panel.add((Component)sub, "South");
                this.panel.add((Component)c, "North");
                this.panel.setBorder(l.getBorder());
                l.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                c = new JLayer<JPanel>(this.panel, new DiagonallySplitCellLayerUI());
            }
        }
        return c;
    }

    private static boolean isDiagonallySplitCell(LocalDate nextWeekDay, LocalDate cur) {
        return YearMonth.from(nextWeekDay).equals(YearMonth.from(cur));
    }

    private void updateWeekColor(LocalDate d, JTable table, Component c, boolean selected) {
        if (selected) {
            c.setForeground(table.getSelectionForeground());
        } else {
            DayOfWeek dayOfWeek = d.getDayOfWeek();
            if (dayOfWeek == DayOfWeek.SUNDAY) {
                c.setForeground(SUNDAY_FGC);
            } else if (dayOfWeek == DayOfWeek.SATURDAY) {
                c.setForeground(SATURDAY_FGC);
            } else if (YearMonth.from(d).equals(YearMonth.from(this.currentLocalDate))) {
                c.setForeground(table.getForeground());
            } else {
                c.setForeground(Color.GRAY);
            }
        }
    }
}

